/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.server.command;

import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.Function;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2408;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_31;
import net.minecraft.class_3754;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5285;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import potionstudios.byg.BYG;
import potionstudios.byg.mixin.access.WorldGenRegistryDumpReportAccess;
import potionstudios.byg.shadow.blue.endless.jankson.Jankson;
import potionstudios.byg.shadow.blue.endless.jankson.JsonObject;
import potionstudios.byg.shadow.blue.endless.jankson.api.SyntaxError;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.jankson.JanksonUtil;

public class WorldGenExportCommand {
    private static final String EXCLUDED = Paths.get("minecraft", new String[0]).resolve("worldgen").resolve("density_function").resolve("zero.json").toString();
    public static final Map<String, String> COMMENTS = (Map)class_156.method_654(new HashMap(), map -> {});

    public static void worldGenExportCommand(CommandDispatcher<class_2168> dispatcher) {
        String commandString = "worldGenExport";
        Function withComments = cs -> (Boolean)((CommandContext)cs).getArgument("With comments?", Boolean.class);
        Function builtin = cs -> (Boolean)((CommandContext)cs).getArgument("Generate Built In Registries?", Boolean.class);
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandString).requires(stack -> stack.method_9259(4))).executes(cs -> WorldGenExportCommand.generateWorldGenExport(true, false, (CommandContext<class_2168>)cs))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"With comments?", (ArgumentType)BoolArgumentType.bool()).executes(cs -> WorldGenExportCommand.generateWorldGenExport((Boolean)withComments.apply((Object)cs), false, (CommandContext<class_2168>)cs))).then(class_2170.method_9244((String)"Generate Built In Registries?", (ArgumentType)BoolArgumentType.bool()).executes(cs -> WorldGenExportCommand.generateWorldGenExport((Boolean)withComments.apply((Object)cs), (Boolean)builtin.apply((Object)cs), (CommandContext<class_2168>)cs)))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)commandString).redirect((CommandNode)source));
    }

    public static int generateWorldGenExport(boolean withComments, boolean builtin, CommandContext<class_2168> commandSource) {
        class_2168 source = (class_2168)commandSource.getSource();
        if (!source.method_9211().method_3724() || source.method_9211().method_3788() > 1) {
            source.method_9213((class_2561)new class_2588("byg.worldgenexport.singleplayer").method_27692(class_124.field_1061));
            return 0;
        }
        Path finalExportPath = ModPlatform.INSTANCE.configPath().getParent().resolve("world_gen_export").resolve(builtin ? "builtin" : "world").resolve("data");
        Path exportPath = finalExportPath.resolve("cache");
        class_5250 exportFileComponent = new class_2585(finalExportPath.toString()).method_27692(class_124.field_1073).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1075)).method_10958(new class_2558(class_2558.class_2559.field_11746, finalExportPath.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2588("byg.clickevent.hovertext"))));
        if (exportPath.toFile().exists()) {
            source.method_9213((class_2561)new class_2588("byg.worldgenexport.exists", new Object[]{exportFileComponent}).method_27692(class_124.field_1061));
            return 0;
        }
        source.method_9226((class_2561)new class_2588("byg.worldgenexport.starting").method_27692(class_124.field_1054), true);
        try {
            WorldGenExportCommand.generateFiles(builtin, source, exportPath);
            if (withComments) {
                WorldGenExportCommand.addComments(exportPath);
            }
            WorldGenExportCommand.setupAndUseDataPackDirectoriesStructure(finalExportPath, exportPath);
            WorldGenExportCommand.createPackMCMeta(finalExportPath.getParent(), builtin);
            source.method_9226((class_2561)new class_2588("byg.worldgenexport.success", new Object[]{exportFileComponent}).method_27692(class_124.field_1060), true);
            return 1;
        }
        catch (IOException e) {
            source.method_9213((class_2561)new class_2588("byg.worldgenexport.failed"));
            e.printStackTrace();
            return 0;
        }
    }

    private static void setupAndUseDataPackDirectoriesStructure(Path finalExportPath, Path exportPath) throws IOException {
        Path result = exportPath.resolve("reports").resolve("worldgen");
        Files.walk(result, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
            try {
                if (path.getFileName().toString().endsWith(".json")) {
                    String newTarget = result.relativize((Path)path).toString();
                    Path newPath = finalExportPath.resolve(newTarget);
                    Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    byte[] bytes = Files.readAllBytes(path);
                    Files.write(newPath, bytes, new OpenOption[0]);
                }
                Files.delete(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        Files.walk(exportPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private static void addComments(Path exportPath) throws IOException {
        Files.walk(exportPath, new FileVisitOption[0]).forEach(path -> {
            boolean skipZero;
            String fileName = path.getFileName().toString();
            boolean bl = skipZero = !path.toString().endsWith(EXCLUDED);
            if (fileName.endsWith(".json") && skipZero) {
                try {
                    JsonObject load = Jankson.builder().build().load(path.toFile());
                    load = JanksonUtil.addCommentsAndAlphabeticallySortRecursively(COMMENTS, load, "", true);
                    Files.write(path, load.toJson(JanksonUtil.JSON_GRAMMAR).getBytes(), new OpenOption[0]);
                }
                catch (IOException | SyntaxError e) {
                    BYG.LOGGER.error(String.format("\"%s\" had errors: ", path.toString()));
                    e.printStackTrace();
                }
            }
        });
    }

    private static void generateFiles(boolean builtin, class_2168 source, Path exportPath) throws IOException {
        class_2408 cache = new class_2408(exportPath, "cache");
        class_5455.class_6893 registry = builtin ? class_5455.method_40314() : source.method_9225().method_30349();
        class_2378 defaultDimensions = class_2874.method_28517((class_5455)registry, (long)0L, (boolean)false);
        class_3754 chunkGenerator = class_5285.method_39558((class_5455)registry, (long)0L, (boolean)false);
        class_6903 ops = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_5455)registry);
        for (class_5455.class_5456 knownRegistry : class_5455.method_39674()) {
            WorldGenRegistryDumpReportAccess.byg_invokeDumpRegistryCap(cache, exportPath, (class_5455)registry, (DynamicOps<JsonElement>)ops, knownRegistry);
        }
        class_2378 worldSettings = builtin ? class_5285.method_28608((class_2378)registry.method_33309(class_2378.field_25095), (class_2378)defaultDimensions, (class_2794)chunkGenerator) : ((class_31)source.method_9211().method_3847(class_1937.field_25179).method_8401()).method_28057().method_28609();
        WorldGenRegistryDumpReportAccess.byg_invokeDumpRegistry(exportPath, cache, (DynamicOps<JsonElement>)ops, class_2378.field_25490, worldSettings, class_5363.field_25411);
    }

    private static void createPackMCMeta(Path path, boolean builtIn) throws IOException {
        String fileString = "{\n\t\"pack\":{\n\t\t\"pack_format\": 9,\n\t\t\"description\": \" Generated world gen datapack from " + (builtIn ? "built in registries" : "current world registries") + ".\"\n\t}\n}\n";
        Files.write(path.resolve("pack.mcmeta"), fileString.getBytes(), new OpenOption[0]);
    }
}

